#==============================================================================
# ■ VXAce_SP1
#------------------------------------------------------------------------------
# 　プリセットスクリプトの不具合を修正します。ユーザー定義のスクリプト素材は、
# 原則としてこのセクションより下に配置してください。
#==============================================================================

#------------------------------------------------------------------------------
# 【修正内容】
#------------------------------------------------------------------------------
# ●イベントコマンド［ステートの変更］にて、同じステートの付加と解除を同時に実
#   行した際、二回目以降の付加が失敗する不具合を修正しました。
# ●イベントコマンド［アニメーションの表示］にて、表示中のアニメーションがマッ
#   プのスクロールに同期しない不具合を修正しました。
# ●自動戦闘の行動が正常に選択されない不具合を修正しました。
# ●装備できなくなった装備品が外れたことにより、さらに別の装備品が装備できなく
#   なったとき、その装備品が増殖してしまう不具合を修正しました。
# ●イベントコマンド［ピクチャの消去］を実行した後に余分な負荷がかかる不具合を
#   修正しました。
# ●移動ルートのオプション［移動できない場合は飛ばす］にチェックを入れた状態で
#   トリガー［プレイヤーから接触］のイベントに接触すると、イベントが実行中であ
#   っても起動予約がされてしまう不具合を修正しました。
# ●魔法反射されたスキルに対してステート有効度が反映されない不具合を修正しまし
# 　た。
# ●フォントのデフォルト設定にて太字または斜体を有効にしていても、ステータス画
#   面を切り替えたとき等に無効な状態に戻ってしまう不具合を修正しました。
#------------------------------------------------------------------------------
class Game_Battler
  attr_accessor :magic_reflection
  #--------------------------------------------------------------------------
  # ● 敵対関係の判定
  #--------------------------------------------------------------------------
  alias vxace_sp1_opposite? opposite?
  def opposite?(battler)
    vxace_sp1_opposite?(battler) || battler.magic_reflection
  end
end
#------------------------------------------------------------------------------
class Game_Actor
  #--------------------------------------------------------------------------
  # ● 装備できない装備品を外す
  #     item_gain : 外した装備品をパーティに戻す
  #--------------------------------------------------------------------------
  alias vxace_sp1_release_unequippable_items release_unequippable_items
  def release_unequippable_items(item_gain = true)
    loop do
      last_equips = equips.dup
      vxace_sp1_release_unequippable_items(item_gain)
      return if equips == last_equips
    end
  end
  #--------------------------------------------------------------------------
  # ● 自動戦闘時の戦闘行動を作成
  #--------------------------------------------------------------------------
  def make_auto_battle_actions
    @actions.size.times do |i|
      @actions[i] = make_action_list.max_by {|action| action.value }
    end
  end
end
#------------------------------------------------------------------------------
class Game_Player
  #--------------------------------------------------------------------------
  # ● マップイベントの起動
  #     triggers : トリガーの配列
  #     normal   : プライオリティ［通常キャラと同じ］かそれ以外か
  #--------------------------------------------------------------------------
  alias vxace_sp1_start_map_event start_map_event
  def start_map_event(x, y, triggers, normal)
    return if $game_map.interpreter.running?
    vxace_sp1_start_map_event(x, y, triggers, normal)
  end
end
#------------------------------------------------------------------------------
class Game_Picture
  #--------------------------------------------------------------------------
  # ● ピクチャの消去
  #--------------------------------------------------------------------------
  alias vxace_sp1_erase erase
  def erase
    vxace_sp1_erase
    @origin = 0
  end
end
#------------------------------------------------------------------------------
class Game_Interpreter
  #--------------------------------------------------------------------------
  # ● ステートの変更
  #--------------------------------------------------------------------------
  alias vxace_sp1_command_313 command_313
  def command_313
    vxace_sp1_command_313
    $game_party.clear_results
  end
end
#------------------------------------------------------------------------------
class Sprite_Character
  #--------------------------------------------------------------------------
  # ● 位置の更新
  #--------------------------------------------------------------------------
  alias vxace_sp1_update_position update_position
  def update_position
    move_animation(@character.screen_x - x, @character.screen_y - y)
    vxace_sp1_update_position
  end
  #--------------------------------------------------------------------------
  # ● アニメーションの移動
  #--------------------------------------------------------------------------
  def move_animation(dx, dy)
    if @animation && @animation.position != 3
      @ani_ox += dx
      @ani_oy += dy
      @ani_sprites.each do |sprite|
        sprite.x += dx
        sprite.y += dy
      end
    end
  end
end
#------------------------------------------------------------------------------
class Sprite_Picture
  #--------------------------------------------------------------------------
  # ● 転送元ビットマップの更新
  #--------------------------------------------------------------------------
  alias vxace_sp1_update_bitmap update_bitmap
  def update_bitmap
    if @picture.name.empty?
      self.bitmap = nil
    else
      vxace_sp1_update_bitmap
    end
  end
end
#------------------------------------------------------------------------------
class Window_Base
  #--------------------------------------------------------------------------
  # ● フォント設定のリセット
  #--------------------------------------------------------------------------
  alias vxace_sp1_reset_font_settings reset_font_settings
  def reset_font_settings
    vxace_sp1_reset_font_settings
    contents.font.bold = Font.default_bold
    contents.font.italic = Font.default_italic
  end
end
#------------------------------------------------------------------------------

